---
title: Cloudflare Managed Ruleset · Cloudflare Web Application Firewall (WAF) docs
description: Created by the Cloudflare security team, this ruleset provides fast
  and effective protection for all of your applications. The ruleset is updated
  frequently to cover new vulnerabilities and reduce false positives.
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/reference/cloudflare-managed-ruleset/
  md: https://developers.cloudflare.com/waf/managed-rules/reference/cloudflare-managed-ruleset/index.md
---

Created by the Cloudflare security team, this ruleset provides fast and effective protection for all of your applications. The ruleset is updated frequently to cover new vulnerabilities and reduce false positives.

Cloudflare recommends that you enable the rules whose tags correspond to your technology stack. For example, if you use WordPress, enable the rules tagged with `wordpress`.

Cloudflare’s [WAF changelog](https://developers.cloudflare.com/waf/change-log/) allows you to monitor ongoing changes to the WAF's managed rulesets.

Note

Some rules in the Cloudflare Managed Ruleset are disabled by default, intending to strike a balance between providing the right protection and reducing the number of false positives.

It is not recommended that you enable all the available rules using overrides, since it may affect legitimate traffic, unless you are running a proof of concept (PoC) to understand what kind of requests the WAF can block.

## Configure in the dashboard

You can configure the following settings of the Cloudflare Managed Ruleset in the Cloudflare dashboard:

* **Set the action to perform.** When you define an action for the ruleset, you override the default action defined for each rule. The available actions are: *Managed Challenge*, *Block*, *JS Challenge*, *Log*, and *Interactive Challenge*. To remove the action override, set the ruleset action to *Default*.
* **Override the action performed by individual rules or rules with specific tags.** The available actions are: *Managed Challenge*, *Block*, *JS Challenge*, *Log*, and *Interactive Challenge*.
* **Disable specific rules or rules with specific tags.**
* **Customize the filter expression.** With a custom expression, the Cloudflare Managed Ruleset applies only to a subset of the incoming requests.
* **Configure [payload logging](https://developers.cloudflare.com/waf/managed-rules/payload-logging/configure/)**.

For details on configuring a managed ruleset in the dashboard, refer to [Configure a managed ruleset](https://developers.cloudflare.com/waf/managed-rules/deploy-zone-dashboard/#configure-a-managed-ruleset).

## Configure via API

To enable the Cloudflare Managed Ruleset for a given zone via API, create a rule with `execute` action in the [entry point ruleset](https://developers.cloudflare.com/ruleset-engine/about/rulesets/#entry-point-ruleset) for the `http_request_firewall_managed` phase.

### Example

The following example deploys the [Cloudflare Managed Ruleset](https://developers.cloudflare.com/waf/managed-rules/reference/cloudflare-managed-ruleset/) to the `http_request_firewall_managed` phase of a given zone (`$ZONE_ID`) by creating a rule that executes the managed ruleset.

1. Invoke the [Get a zone entry point ruleset](https://developers.cloudflare.com/api/resources/rulesets/subresources/phases/methods/get/) operation to obtain the definition of the entry point ruleset for the `http_request_firewall_managed` phase. You will need the [zone ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) for this task.

   ```bash
   curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/phases/http_request_firewall_managed/entrypoint" \
     --request GET \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
   ```

   ```json
   {
     "result": {
       "description": "Zone-level phase entry point",
       "id": "<RULESET_ID>",
       "kind": "zone",
       "last_updated": "2024-03-16T15:40:08.202335Z",
       "name": "zone",
       "phase": "http_request_firewall_managed",
       "rules": [
         // ...
       ],
       "source": "firewall_managed",
       "version": "10"
     },
     "success": true,
     "errors": [],
     "messages": []
   }
   ```

2. If the entry point ruleset already exists (that is, if you received a `200 OK` status code and the ruleset definition), take note of the ruleset ID in the response. Then, invoke the [Create a zone ruleset rule](https://developers.cloudflare.com/api/resources/rulesets/subresources/rules/methods/create/) operation to add an `execute` rule to the existing ruleset deploying the Cloudflare Managed Ruleset (with ID `efb7b8c949ac4650a09736fc376e9aee`). By default, the rule will be added at the end of the list of rules already in the ruleset.

   ```bash
   curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID/rules" \
     --request POST \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
     --json '{
       "action": "execute",
       "action_parameters": {
           "id": "efb7b8c949ac4650a09736fc376e9aee"
       },
       "expression": "true",
       "description": "Execute the Cloudflare Managed Ruleset"
     }'
   ```

   ```json
   {
     "result": {
       "id": "<RULESET_ID>",
       "name": "Zone-level phase entry point",
       "description": "",
       "kind": "zone",
       "version": "11",
       "rules": [
         // ... any existing rules
         {
           "id": "<RULE_ID>",
           "version": "1",
           "action": "execute",
           "action_parameters": {
             "id": "efb7b8c949ac4650a09736fc376e9aee",
             "version": "latest"
           },
           "expression": "true",
           "description": "Execute the Cloudflare Managed Ruleset",
           "last_updated": "2024-03-18T18:08:14.003361Z",
           "ref": "<RULE_REF>",
           "enabled": true
         }
       ],
       "last_updated": "2024-03-18T18:08:14.003361Z",
       "phase": "http_request_firewall_managed"
     },
     "success": true,
     "errors": [],
     "messages": []
   }
   ```

3. If the entry point ruleset does not exist (that is, if you received a `404 Not Found` status code in step 1), create it using the [Create a zone ruleset](https://developers.cloudflare.com/api/resources/rulesets/methods/create/) operation. Include a single rule in the `rules` array that executes the Cloudflare Managed Ruleset (with ID `efb7b8c949ac4650a09736fc376e9aee`) for all incoming requests in the zone.

   ```bash
   curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets" \
     --request POST \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
     --json '{
       "name": "My ruleset",
       "description": "Entry point ruleset for WAF managed rulesets",
       "kind": "zone",
       "phase": "http_request_firewall_managed",
       "rules": [
           {
               "action": "execute",
               "action_parameters": {
                   "id": "efb7b8c949ac4650a09736fc376e9aee"
               },
               "expression": "true",
               "description": "Execute the Cloudflare Managed Ruleset"
           }
       ]
     }'
   ```

### Next steps

To configure the Cloudflare Managed Ruleset via API, create [overrides](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/) using the Rulesets API. You can perform the following configurations:

* Specify the action to perform for all the rules in the ruleset by creating a ruleset override.

* Disable or customize the action of individual rules by creating rule overrides.

For examples of creating overrides using the API, refer to [Override a managed ruleset](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/).

### More resources

For more information on working with managed rulesets via API, refer to [Work with managed rulesets](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/) in the Ruleset Engine documentation.
