---
title: Render · Cloudflare Style Guide
description: The Render component allows us to include a "partial", a reusable
  Markdown snippet, onto a page.
lastUpdated: 2025-08-22T15:47:29.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/render/
  md: https://developers.cloudflare.com/style-guide/components/render/index.md
---

The `Render` component allows us to include a "partial", a reusable Markdown snippet, onto a page.

It also accepts parameters that can be used as variables within the partial, so that even content which needs slight differences between usages can be turned into a partial.

## Component

### Inputs

* `file` string

  This should be the name of the partial, without the containing directory or file extension. For example, `/partials/style-guide/hello.mdx` would be `file="hello"`.

* `product` string

  This should be the folder within `src/partials`.

* `params` object optional

  If you wish to substitute values inside your partial, you can use pass params which can be referenced in your partial. Refer to [properties](#properties).

## Properties

### Defining expected properties in frontmatter

Anything defined in the `params` property of the `Render` component is available inside the partial, using [JavaScript expressions](https://mdxjs.com/docs/using-mdx/).

To protect against required properties being missed, any partial that relies on `params` should also define `params` in the partial's frontmatter. This should be an array of strings, matching the property names you expect. If a property is optional, such as for [conditional content](#properties-to-render-content-conditionally), add a `?` to the end of the name.

```mdx
---
params:
  - product
  - deprecated?
---
```

Warning

If you use the Markdown component to format your optional parameter, you need to craft it in a special way so you don't get an `Undefined` error in pages without the optional parameter.

Say, for example, that your optional parameter is `instructions`. You would craft it like this:

`{props.instructions && <Markdown text={props.instructions} />}`

instead of `<Markdown text={props.instructions} />`

For each of the below examples, you can open the dropdown to view the partial's content.

### Properties as a plain string

The below example would render `Hello, world!`.

simple-props.mdx

```mdx
---
params:
  - name
---


Hello, {props.name}!
```

### Properties in Markdown syntax

When using JavaScript expressions, you are now "inside JSX" and cannot use traditional Markdown syntax. Similarly, you cannot use a JavaScript expression inside Markdown syntax.

Ideally, you should not use Markdown syntax, such as `**strong**` or `[text](link)`, with properties. If using JSX is not feasible, there is a [`Markdown`](https://developers.cloudflare.com/style-guide/components/markdown/) component that will take a `text` property.

The [MDX documentation](https://mdxjs.com/table-of-components/#components) includes a mapping of common Markdown syntax to their equivalent JSX elements.

#### Strong

strong-in-props.mdx

```mdx
---
params:
  - dont
  - do
---


**Don't do this!**


{props.dont}


**Do this!**


<strong>{props.do}</strong>
```

#### Links

link-in-props.mdx

```mdx
---
params:
  - link
---


**Don't do this!**


This will link to `/style-guide/components/%7Bprops.link%7D`.


[Markdown link]({props.link})


**Do this!**


This will link to `style-guide/components/render/#links`.


<p>
  <a href={props.link}>JSX link</a>
</p>
```

#### Images

image-in-props.mdx

```mdx
---
params:
  - image
---


**Don't do this!**


`![Alt text]({props.image})`


**Do this!**


<img src={props.image} alt="Alt text" />
```

#### Code blocks

code-in-props.mdx

````mdx
---
params:
  - code
---


import { Code } from "~/components";


#### Inline


**Don't do this!**


`{props.code}`


**Do this!**


<p>
  <code>{props.code}</code>
</p>


<hr />


#### Codeblocks


**Don't do this!**


```js
{
  props.code;
}
```


**Do this!**


<Code code={props.code} lang="js" />
````

### Properties to render content conditionally

Anything that you can represent in a JavaScript expression can be used in your conditional logic.

This may be the [and (`&&`) operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Logical_AND) or [ternary (`? ... : ... `) operator](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Conditional_operator), the below example uses both.

optional-props.mdx

```mdx
---
params:
  - product
  - deprecated?
---


{
props.deprecated && (
<p>
<strong>
{props.product} is deprecated, please use alternative products.
</strong>
</p>
)
}


{
props.product === "Thing Three" ? (
<p>Welcome to our Thing Three launch countdown!</p>
) : (
<p>Welcome to the {props.product} landing page.</p>
)
}
```

## Partials
