---
title: http.request.headers · Cloudflare Ruleset Engine docs
description: The HTTP request headers represented as a Map (or associative array).
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.headers/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.headers/index.md
---

# http.request.headers

`http.request.headers` Map\<Array\<String>>

The HTTP request headers represented as a Map (or associative array).

The keys of the associative array are the names of HTTP request headers converted to lowercase.

When there are repeating headers, the array includes them in the order they appear in the request.

The request header values are not pre-processed and retain the original case used in the request.

* **Decoding**: No decoding performed
* **Whitespace**: Preserved
* **Non-ASCII**: Preserved

When the HTTP request contains too many headers, this field may not contain all of the headers sent in the HTTP request. In this situation, the [`http.request.headers.truncated`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.headers.truncated/) field will be set to `true`.

Example value:

```txt
{"content-type": ["application/json"]}
```

Example usage:

```txt
any(http.request.headers["content-type"][*] == "application/json")
```

Categories:

* Request
* Headers
