---
title: Unexpected _acme-challenge TXT records · Cloudflare DNS docs
description: You might notice TXT records like _acme-challenge.<hostname> are
  returned by your domain but cannot be found on the DNS tab of your Cloudflare
  dashboard.
lastUpdated: 2025-07-03T09:48:32.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/manage-dns-records/troubleshooting/acme-challenge-txt-record/
  md: https://developers.cloudflare.com/dns/manage-dns-records/troubleshooting/acme-challenge-txt-record/index.md
---

You might notice TXT records like `_acme-challenge.<hostname>` are returned by your domain but cannot be found on the DNS tab of your Cloudflare dashboard.

## Causes

These records are automatically created to allow Cloudflare edge certificates ([universal](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/), [advanced](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/), and [backup](https://developers.cloudflare.com/ssl/edge-certificates/backup-certificates/)) to be provisioned. `_acme-challenge` records are required by certificate authorities (CAs) so that they can verify your domain ownership before issuing the SSL/TLS certificate. For details, refer to [Domain control validation (DCV)](https://developers.cloudflare.com/ssl/edge-certificates/changing-dcv-method/).

## Solution

As these records are tied to the certificates, they cannot be deleted from the DNS tab of your Cloudflare dashboard.

If you need more `_acme-challenge.<hostname>` TXT records in order to provision certificates on your side, you can [manually add them](https://developers.cloudflare.com/dns/manage-dns-records/how-to/create-dns-records/) under [DNS records](https://dash.cloudflare.com/?to=/:account/:zone/dns/records).

If you want to remove these records:

* [Disable Universal SSL](https://developers.cloudflare.com/ssl/edge-certificates/universal-ssl/disable-universal-ssl/) to remove the records related to universal and backup certificates.
* [Delete advanced certificates](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/manage-certificates/#delete-a-certificate) to remove the records related to advanced certificates.
