---
title: Debug, profile, and view logs for your Worker in Chrome Devtools — now
  supported in the Cloudflare Vite plugin · Changelog
description: The Cloudflare Vite plugin now supports debugging Cloudflare
  Workers using Chrome Devtools
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-05-21-vite-plugin-chrome-devtools/
  md: https://developers.cloudflare.com/changelog/2025-05-21-vite-plugin-chrome-devtools/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Debug, profile, and view logs for your Worker in Chrome Devtools — now supported in the Cloudflare Vite plugin

May 30, 2025

[Workers](https://developers.cloudflare.com/workers/)

You can now [debug, profile, view logs, and analyze memory usage for your Worker](https://developers.cloudflare.com/workers/observability/dev-tools/) using [Chrome Devtools](https://developer.chrome.com/docs/devtools) when your Worker runs locally using the [Cloudflare Vite plugin](https://developers.cloudflare.com/workers/vite-plugin/).

Previously, this was only possible if your Worker ran locally using the [Wrangler CLI](https://developers.cloudflare.com/workers/wrangler/), and now you can do all the same things if your Worker uses [Vite](https://vite.dev/).

When you run `vite`, you'll now see a debug URL in your console:

```plaintext
  VITE v6.3.5  ready in 461 ms


  ➜  Local:   http://localhost:5173/
  ➜  Network: use --host to expose
  ➜  Debug:   http://localhost:5173/__debug
  ➜  press h + enter to show help
```

Open the URL in Chrome, and an instance of Chrome Devtools will open and connect to your Worker running locally. You can then use Chrome Devtools to debug and introspect performance issues. For example, you can navigate to the Performance tab to understand where CPU time is spent in your Worker:

![CPU Profile](https://developers.cloudflare.com/_astro/profile.Dz8PUp_K_Z13cVAd.webp)

For more information on how to get the most out of Chrome Devtools, refer to the following docs:

* [Debug code by setting breakpoints](https://developers.cloudflare.com/workers/observability/dev-tools/breakpoints/)
* [Profile CPU usage](https://developers.cloudflare.com/workers/observability/dev-tools/cpu-usage/)
* [Observe memory usage and debug memory leaks](https://developers.cloudflare.com/workers/observability/dev-tools/memory-usage/)
