---
title: Always Online · Cloudflare Cache (CDN) docs
description: Cloudflare’s Always Online feature is now integrated with the
  Internet Archive so that visitors can access a portion of your website even
  when your origin server is unreachable and a Cloudflare-cached version is
  unavailable. When your origin is unreachable, Always Online checks
  Cloudflare’s cache for a stale or expired version of your website. If a
  version does not exist, Cloudflare goes to the Internet Archive to fetch and
  serve static portions of your website.
lastUpdated: 2025-10-06T13:41:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/how-to/always-online/
  md: https://developers.cloudflare.com/cache/how-to/always-online/index.md
---

Cloudflare’s Always Online feature is now integrated with the [Internet Archive](https://archive.org/) so that visitors can access a portion of your website even when your origin server is unreachable and a Cloudflare-cached version is unavailable. When your origin is unreachable, Always Online checks Cloudflare’s cache for a stale or expired version of your website. If a version does not exist, Cloudflare goes to the Internet Archive to fetch and serve static portions of your website.

When you enable Always Online with Internet Archive integration, Cloudflare shares your hostname and popular URL paths with the archive so that the Internet Archive’s crawler stores the pages you want archived. When submitting targets to the crawler, Cloudflare identifies the most popular URLs found among GET requests that returned a 200 HTTP status code in the previous five hours.

Note that Cloudflare does not save a copy of every page of your website, and it cannot serve dynamic content while your origin is offline. If the requested page is not in the Internet Archive's Wayback Machine, the visitor sees the actual error page caused by the offline origin web server.

When the Internet Archive integration is enabled, Cloudflare tells the Internet Archive what pages to crawl and how often. The pages to crawl, as previously mentioned, are the most popular URLs that were successfully visited in the last five hours. The crawling intervals, to ensure stability of service, are limited by Cloudflare. Limits vary according to your Cloudflare plan.

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |
| Crawl interval | Every 30 days | Every 15 days | Every 5 days | Every 5 days |

## Visitor Experience

When Always Online with Internet Archive integration is enabled, visitors see a banner at the top of the webpage explaining they are visiting an archived version of the website. Visitors can select the Refresh button to check whether the origin has recovered and fresh content is available.

When a visitor requests content for an offline website, Cloudflare returns an HTTP response status code in the range [520–527](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-520/), depending on the issue. These status codes indicate that the origin is unreachable.

When the Internet Archive integration is enabled, Cloudflare checks the archive and serves the most recently archived version of the page.

Visitors who interact with dynamic parts of a website, such as a shopping cart or comment box, will see an error page caused by the offline origin web server.

## Enable Always Online

Here is how to enable Always Online in the dashboard:

1. In the Cloudflare dashboard, go to the **Configuration** page.

   [Go to **Configuration**](https://dash.cloudflare.com/?to=/:account/:zone/caching/configuration)

2. Choose the domain that will use Always Online with Internet Archive integration.

3. Under **Always Online**, set the toggle to **On**.

Note

When turning on Always Online, you are also enabling the Internet Archive integration.

Refer to [Always Online](https://developers.cloudflare.com/cache/troubleshooting/always-online/) for best practices, limitations, and FAQs.
